/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser.DisplayPort;

public abstract class DisplayPortMessage {
    private int aMessageType;
    private byte[] aData = null;
    protected boolean aIsError = false;

    public DisplayPortMessage(int n, byte[] byArray) {
        this.aMessageType = n;
        this.aData = byArray;
    }

    public abstract int getAddress();

    public abstract String getDirection();

    public abstract boolean isMotSet();

    public abstract String getMessageTypeText();

    public abstract String getSummary();

    public abstract String getDetails();

    public abstract int getDataLength();

    public int getMessageType() {
        return this.aMessageType;
    }

    public byte[] getData() {
        return this.aData;
    }

    public boolean isError() {
        return this.aIsError;
    }

    protected boolean isNative() {
        boolean bl = false;
        switch (this.aMessageType) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean hasData() {
        return this.aData != null;
    }

    public abstract boolean isEvent();

    public abstract boolean isI2C();

    public abstract boolean isHDCP();

    public abstract boolean isDDCCI();

    public abstract boolean isEDID();

    public abstract boolean isLT();
}

